package gov.va.med.mhv.health.model;

import java.io.Serializable;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@Entity
@Table(name="MEDICAL_EVENTS")
public class MedicalEvent implements Serializable{
	
	private static final long serialVersionUID = -5431461910741814090L;
	
    @Id
	@Column(name="MEDICAL_EVENT_ID_SEQ")
	@GeneratedValue(strategy=GenerationType.AUTO) 
	private Long id;
    
	@Column(name="OPLOCK")
	private Integer oplock;
	
	@Column(name="COMMENTS")
	private String comments;
	
	
	@Column(name="START_DATE")
	@Temporal(TemporalType.TIMESTAMP)
	private Date startDate;
	
	
	@Column(name="STOP_DATE")
	@Temporal(TemporalType.TIMESTAMP)
	private Date stopDate;
	
	
	@Column(name="MEDICAL_EVENT")
	private String medicalEvent;
	
	
	@Column(name="RESPONSE")
	private String response;

	
	@Column(name="USER_PROFILE_USER_PROFILE_ID")
	private Long userprofileId;


	public Long getId() {
		return id;
	}


	public void setId(Long id) {
		this.id = id;
	}


	public Integer getOplock() {
		return oplock;
	}


	public void setOplock(Integer oplock) {
		this.oplock = oplock;
	}


	public String getComments() {
		return comments;
	}


	public void setComments(String comments) {
		this.comments = comments;
	}


	public Date getStartDate() {
		return startDate;
	}


	public void setStartDate(Date startDate) {
		this.startDate = startDate;
	}


	public Date getStopDate() {
		return stopDate;
	}


	public void setStopDate(Date stopDate) {
		this.stopDate = stopDate;
	}


	public String getMedicalEvent() {
		return medicalEvent;
	}


	public void setMedicalEvent(String medicalEvent) {
		this.medicalEvent = medicalEvent;
	}


	public String getResponse() {
		return response;
	}


	public void setResponse(String response) {
		this.response = response;
	}


	public Long getUserprofileId() {
		return userprofileId;
	}


	public void setUserprofileId(Long userprofileId) {
		this.userprofileId = userprofileId;
	}


}
